import Fastify from 'fastify'
import {Stan} from 'stan-api';

const fastify = Fastify({
  logger: true
})

fastify.route({
    method: 'GET',
    url: '/lignes',
    schema: {
	// request needs to have a querystring with a `name` parameter
	querystring: {
	    type: 'object',
	    properties: {
		name: { type: 'string'}
	    },
	    required: ['name'],
	},      
    },
    preHandler: async (request, reply) => {
	// E.g. check authentication
    },
    handler: async (request, reply) => {
	const lignes= (await Stan.getLignes());
	//return { hello: 'world' }
	return lignes;
    }
});

fastify.route{
    method: 'GET',
    url: '/arret',
    schema: {
	querystring: {
	    type: 'object',
	    properties: {
		id: { type: 'string'}
	    },
	    required: ['id'],
	},      
    },
    handler: async (request, reply) => {
	const arret= (await Stan.getArret(request.params.id));
	return arret;
    }
});

try {
  await fastify.listen({ port: 80 })
} catch (err) {
  fastify.log.error(err)
  process.exit(1)
}
